/*! \file 
**********************************************************************************
*Title:                         Discretix OMA DRM v2 Toolkit source file
*
* Filename:                     ODRM_TLK_ATP_data.h
*
* Project, Target, subsystem:   Toolkit, OMA DRM
* 
* Created:                      03.12.2007
*
* \Author                       Sagitb
*
* \Remarks
*           Copyright (C) 2007 by Discretix Technologies Ltd. All Rights reserved.
**********************************************************************************/

#ifndef _ODRM_TLK_ATP_DATA_H_
#define _ODRM_TLK_ATP_DATA_H_

#include "DX_VOS_BaseTypes.h"
#include "ODRM_TLK_ATP_Defines.h"

extern DxUint8_t   TST_gKeyRingBuf[ODRMTLK_TST_MAX_SIZE_KEY_RING_BUF];
extern DxByte_t    TST_gWorkspace[ODRMTLK_TST_WORKSPACE_SIZE];
extern DxByte_t    TST_gDevKeyRingBuf[ODRMTLK_TST_MAX_SIZE_DEV_KEY_RING_BUF];
extern DxUint32_t  TST_gNumOfSymKeys ;
extern DxUint32_t  TST_gNumOfRSAKeys;
extern DxUint32_t  TST_gNumOfDHKeys ;
extern DxUint32_t  TST_gRequiredBufSizeInBytes;
extern DxUint32_t  TST_gWorkspaceSizeInBytes;
extern DxUint8_t   TST_gPassword[ODRMTLK_TST_KEY_PASS_LENGTH_IN_BYTES];
extern DxUint32_t  TST_gPasswordSize;
extern CRYS_AES_IvCounter_t  TST_gIvCounter ;

extern DxUint8_t   TST_gPrivExponent[];
extern DxUint16_t  TST_gPrivExponentSize;
extern DxUint8_t   TST_gModulus[];
extern DxUint16_t  TST_gModulusSize;
extern DxUint8_t   TST_gPubExponent[3];
extern DxUint16_t  TST_gPubExponentSize;

extern DxByte_t    TST_gKey[ODRMTLK_TST_AES_KEY_SIZE];
extern DxByte_t    TST_gKeyData[ODRMTLK_TST_AES_KEY_SIZE];
extern DxByte_t    TST_gPlainBuff[ODRMTLK_TST_AES_KEY_SIZE];
extern DxByte_t    TST_gEncryptedDataOut[ODRMTLK_TST_AES_KEY_SIZE];
extern DxByte_t    TST_gEncryptKeyData[ODRMTLK_TST_AES_KEY_SIZE];

extern DxByte_t    TST_gEncryptedPlainBuffWithK[ODRMTLK_TST_AES_KEY_SIZE];
extern DxByte_t    TST_gKekkey[ODRMTLK_TST_AES_KEY_SIZE];
extern DxByte_t    TST_gWrappedKkey[ODRMTLK_TST_WRAPPED_KEY_LENGTH_IN_BYTES];
extern DxByte_t    TST_gWrappedCekWithRek[ODRMTLK_TST_WRAPPED_KEY_LENGTH_IN_BYTES];
extern DxByte_t    TST_gKMacAndkRekBuff[ODRMTLK_TST_DOUBLE_AES_KEY_SIZE];
extern DxByte_t    TST_gCBuff[ODRMTLK_TST_CBUFF_SIZE];
extern DxByte_t    TST_gHmacPlainBuffWithKmac[];
extern CRYS_HASH_Result_t  TST_gHmacResultBuff;
extern DxByte_t    TST_gC[ODRMTLK_TST_C_SIZE];
extern DxByte_t    TST_gZ[Z_SIZE];
extern DxByte_t    TST_gC1[ODRMTLK_TST_RSA_1024_KEY_SIZE_IN_BYTES];
extern CRYS_RSAUserPrivKey_t   TST_gRiPrivKey;
extern CRYS_RSAUserPubKey_t    TST_giPubKey;
extern CRYS_RSAKGData_t        TST_gKeyGenData; 
extern CRYS_RSAPrimeData_t     TST_gPrimeData;
extern DxByte_t                TST_gKMacAndkMekBuff[ODRMTLK_TST_DOUBLE_AES_KEY_SIZE];
extern DxByte_t                TST_gC2Buff[ODRMTLK_TST_C2_SIZE ];
extern DxByte_t                TST_gZBuff[ODRMTLK_TST_RSA_1024_KEY_SIZE_IN_BYTES];






#endif
